package djmime

func Mime_type(array []string) (mimetype string) {
	for _, v := range array {
		if "text/plain" == v {
			mimetype = "txt"
			return
		} else if "text/html" == v {
			mimetype = "html"
			return
		} else if "image/url" == v {
			mimetype = "url"
			return
		} else if "image/sql" == v {
			mimetype = "sql"
			return
		} else if "image/jpg" == v || "image/gif" == v || "image/jpeg" == v || "image/png" == v {
			mimetype = "web"
			return
		} else {
			mimetype = "web"
			return
		}
	}
	return "NULL"
}
